--agora é o node(nó)
--o node é uma estrutura maior feita apartir de tokens
--enquanto o token representa "pedaços" do texto,
--o node representa "partes com estrutura" do código

--nodes podem conter outros nodes pois são organizados como uma árvore (AST - Abstract Syntax Tree)

--exemplo simples usando uma expressão matemática
--1 + 2
--Expression{Number{1} + Number{2}}

--outro exemplo mas agora tendo precedencia
--1 + 2 * 3
--Expression{Number{1} + Expression{Number{2} * Number{3}}}
--como podem ver, uma expressão pode ter outra
--e como o '*' tem uma precedencia maior que '+' e '-' então 2 * 3 ficam juntos e serão executados primeiro
--enquanto o 1 envolve/empacota/embrulha o resultado de 2 * 3 como se fosse uma caixa
--e quando for executado será 1 + 6, no fim resulta em 7
--2 * 3 = 6
--1 + 6 = 7

--assim como o token, o node também tem o "kind" e o "value"
--o node é criado e organizado como árvore pelo parser

--os tipos/nomes/identificações possiveis de nodes
---@alias NodeKind
---| "LiteralNil"
---| "LiteralBoolean"
---| "LiteralNumber"
---| "LiteralString"
---| "LiteralTable"
---| "LiteralCallable"
---
---| "DeclareStatement"
---| "FunctionStatement"
---| "DeferStatement"
---| "ForStatement"
---| "WhileStatement"
---| "IfStatement"
---| "BlockStatement"
---| "AssignmentStatement"
---| "StatementExpression"
---
---| "Reference"
---| "Callable"
---| "IndexAccess"
---| "CallAccess"
---
---| "ArithmeticExpression"
---| "ComparisionExpression"
---| "LogicalExpression"
---| "GroupedExpression"
---| "UnaryExpression"

---@class Node
---@field __type "Node"
---@field kind NodeKind
---@field value any
local Node = {}
Node.__index = Node
Node.__type = "Node"
---cria um novo node
---@param kind NodeKind
---@param value any
---@return Node
function Node.new(kind, value)
    return setmetatable({
        kind = kind,
        value = value
    }, Node)
end
return Node